// tslint:disable:no-any
import React from 'react';
import { useSelector } from 'react-redux';

import { IAppState } from 'store';
import { TContainerRef } from 'store/popups/types';

export function usePopupsContainerRef() {
    return useSelector<IAppState, TContainerRef>(state => state.popups.containerRef);
}

export function withDefaultSelectScope(Select: any) {
    /* eslint-disable camelcase */
    return ({ unsafe_scope = usePopupsContainerRef(), ...otherProps }: any) => (
        <Select {...otherProps} unsafe_scope={unsafe_scope} />
    );
    /* eslint-enable camelcase */
}

export function withDefaultPopupScope(Popup: any) {
    return ({ scope = usePopupsContainerRef(), ...otherProps }: any) => (
        <Popup {...otherProps} scope={scope} />
    );
}
