import { useCallback, useState } from 'react';

export function useToggle(initialValue: boolean = false) {
    const [value, setValue] = useState(initialValue);

    return {
        value,
        switchOn: useCallback(() => setValue(true), []),
        switchOff: useCallback(() => setValue(false), []),
        toggle: useCallback(() => setValue(currentValue => !currentValue), [])
    };
}
