import { ActionType, IAction, IProps, IState } from './types';

export function getInitialState(props: IProps): IState {
    if (!props.agency) {
        return { isLoading: false, agency: null };
    }

    const { agency, agenciesPageUrl } = props;

    return {
        agency,
        agenciesPageUrl,
        isLoading: false
    };
}

export function reducer(state: IState, action: IAction): IState {
    switch (action.type) {
        case ActionType.StartLoading:
            return { ...state, isLoading: true };

        case ActionType.FinishLoading:
            return {
                agency: action.payload.agency,
                agenciesPageUrl: state.agenciesPageUrl,
                isLoading: false
            };

        default:
            return state;
    }
}
