import { IAgency } from 'client/common/types';

import { IAgencyMetrics } from './../../types/agencies';

export interface IAgencyRouteParams {
    slug: string;
}

export interface IFetchAgencyOpts {
    secretKey: string;
    slug: string;
    agencyUrl: string;
}

export interface IProps {
    agency: IAgency | null;
    agenciesPageUrl: string;
    agencyUrl: string;
    metrics: IAgencyMetrics;
}

export interface IState {
    agency: IAgency | null;
    agenciesPageUrl?: string;
    isLoading: boolean;
}

export enum ActionType {
    StartLoading,
    FinishLoading
}

export interface IStartLoadingAction {
    type: ActionType.StartLoading;
}

export interface IFinishLoadingAction {
    type: ActionType.FinishLoading;
    payload: {
        agency: IAgency;
        agenciesPageUrl?: string;
    };
}

export type IAction =
    | IStartLoadingAction
    | IFinishLoadingAction;
