import { ISolution, TFiltersByCategory } from 'client/common/types';

export enum ActionTypes {
    PUSH_LIST = '[solutions] push list',
    SET_ERROR = '[solutions] set error',
    START_LOADING = '[solutions] start loading',
    RESET_LIST = '[solutions] reset list'
}

interface ISetListPayload {
    list: ISolution[];
    more: boolean;
    hasMore: TFiltersByCategory;
}

interface ISetListAction {
    type: ActionTypes.PUSH_LIST;
    payload: ISetListPayload;
}

interface ISetErrorAction {
    type: ActionTypes.SET_ERROR;
}

interface IStartLoadingAction {
    type: ActionTypes.START_LOADING;
}

interface IResetListAction {
    type: ActionTypes.RESET_LIST;
}

export type TSolutionsAction =
    | ISetListAction
    | IStartLoadingAction
    | ISetErrorAction
    | IResetListAction;
