import { ActionTypes, TSolutionsAction } from './actions';

import { ISolutionsPageState } from '.';

export function reducer(state: ISolutionsPageState, action: TSolutionsAction): ISolutionsPageState {
    switch (action.type) {
        case ActionTypes.PUSH_LIST: {
            const { list, more, hasMore } = action.payload;

            return {
                ...state,
                solutionsList: state.solutionsList.concat(list),
                solutionsCount: state.solutionsList.length + list.length,
                loading: false,
                more,
                hasMore
            };
        }
        case ActionTypes.SET_ERROR:
            return { ...state, loading: false, loadingError: true };
        case ActionTypes.START_LOADING:
            return { ...state, loading: true };
        case ActionTypes.RESET_LIST:
            return { ...state, solutionsList: [], solutionsCount: 0, loading: true, more: true };
        default:
            return state;
    }
}
