import { ISeo } from 'client/common/types/meta';
import { IPost } from 'client/common/types/news';
import { ISolution } from 'client/common/types/solutions';

import { IEnumValue, IGeoValue } from './common';

export type TOtherGroup = 'offices' | 'partners';
export type TGroup = 'main' | TOtherGroup;

export interface IAgenciesPageData {
    description: string;
    filterUrl: string;
    defaultFilters: IAgenciesDefaultFilters;
    budgetConfig: IBudgetConfig;
    title: string;
    filtersTemplate: string;
}

interface IAgenciesList {
    agencies: IAgency[];
    hasMore: boolean;
    seed: string;
    isLoading?: boolean;
}

export interface IAgenciesLists {
    main: IAgenciesList;
    offices: IAgenciesList;
    partners: IAgenciesList;
}

export interface IAgencyPageData {
    agency: IAgency;
    contactPageUrl: string;
    agenciesPageUrl: string;
    agencyUrl: string;
    metrics: IAgencyMetrics;
}

export interface IServicesEnumValue extends IEnumValue {
    certificates: string[];
}

export interface IAgenciesFilters {
    certificates: IEnumValue[];
    cities: IGeoValue[];
    countries: IGeoValue[];
    services: IServicesEnumValue[];
}

export interface IAgenciesDefaultFilters {
    country: string;
    city: string[];
    certificate: CertificateType[];
    service: string[];
}

export interface IBudgetConfig {
    hasFilter?: boolean;
}

export interface IAgenciesConfig {
    groupsByCountryGeoId: {
        [key: string]: TOtherGroup;
    };
    agency: IAgencyConfig;
}

export interface IAgencyConfig {
    logo: {
        default: string;
    };
    description: {
        maxPreviewLength: number;
        maxLength: number;
    };
}

export interface IAgency {
    site: string;
    name: string;
    slug: string;
    representative: string;
    logo: string;
    types: IEnumValue[];
    offices: IOffice[];
    description: string;
    directBudget: number | null;
    directCompanyType: string | null;
    certificates: Array<IEnumValue<CertificateType>>;
    materials: IMaterial[];
    isPartner: boolean;
    productsInfo: IAgencyProductsInfo[];
    seo: ISeo;
}

export interface IAgencyProductsInfo {
    'product_slug': 'market';
    metrics: IAgencyMetricProductsInfo[];
    'total_slug': '_total';
}

export interface IAgencyMetricProductsInfo {
    value: number;
    slug: '_total';
}

export interface IAgencyMetrics {
    [key: string]: {
        active: boolean;
        'avg_value': number;
        'max_value': number;
        title: {
            ru: string;
        }
    };
}
export type TMetricAgencyKeys = '_total' | 'activity' | 'api' | 'assortment-increase' | 'bidder' | 'expertise' | 'gmv-growth' | 'growth' | 'mistakes' | 'quality-index' | 'rating' | 'regions' | 'showcase-conversion' | 'survey' |'yandex_metrika';

export interface IOffice {
    id: number;
    address: string;
    city: IGeoValue;
    email: string;
    isMain: boolean;
    latitude: string;
    longitude: string;
    map: Map;
    mapZoom: number;
    phone: string;
}

export interface ICommonMaterial {
    cardType?: string;
    url: string;
    date: string;
}

export interface ICaseMaterial extends ICommonMaterial {
    type: MaterialType.case;
    data: ISolution;
}

export interface IPostMaterial extends ICommonMaterial {
    type: MaterialType.news;
    data: IPost;
}

export type IMaterial = ICaseMaterial | IPostMaterial;

export enum MaterialType {
    case = 'solutions/cases',
    news = 'news'
}

export enum CertificateType {
    Direct = 'direct',
    Metrica = 'metrika',
    Market = 'market',
    Toloka = 'toloka',
    Dialogs = 'dialogs'
}

export enum Country {
    Russia = 225,
    Belarus = 149,
    Kazakhstan = 159
}

export enum Map {
    yandex = 'yandex',
    openStreetMap = 'osm'
}
