import { IAgenciesConfig, IAgenciesPageData, IAgencyPageData } from './agencies';
import { ICommonData, ILink, TRegion } from './common';
import { TLevel } from './levels';
import { IPhoneData, ISideMenu } from './menu';
import { IOpenGraph, ISeo } from './meta';
import { IMetrika } from './metrika';
import { ISolutionsData } from './solutions';

export interface IAppData {
    avatarsHost: string;
    passportHost: string;
    tld: string;
    basename: string;
    homeUrl: string;
    language: string;
    mordaHost: string;
    url: string;
    userInfo: IUserInfo;
    uatraits: {
        isMobile: boolean;
    };
    settings: ISettings;
    prefooter: IPrefooterSection[];
    siteSearchUrl: string;
    regions: TRegion[];
    seo?: ISeo;
    faviconUrl: string;
    og?: IOpenGraph;
    secretKey: string;
    solutionsData: ISolutionsData;
    solutionsUrl: string;
    filterUrl: string;
    section: string;
    metrikaCounters: IMetrika[];
    metrikaCountersParams: {
        clickmap: boolean;
        trackLinks: boolean;
        accurateTrackBounce: boolean;
    };
    levels: TLevel[];
    mainMenu: ISideMenu;
    shareScript: string;
    mapsApi?: string;
    shareServices: string[];
    commonData: ICommonData;
    htmlMappings: { [key: string]: string };
    agenciesConfig: IAgenciesConfig;
    agenciesPage: IAgenciesPageData;
    agencyPage: IAgencyPageData;
    prevAgencyUrl: string;
    nextAgencyUrl: string;
    contactFormPath: string;
}

export interface IUserInfo {
    avatarId?: string;
    displayName?: string;
    email?: string;
    uid?: string;
    yandexuid?: string;
}

export interface ISettings {
    footer: IFooterData;
}

interface IFooterData extends IPhoneData {
    metrikaGoalId: string;
    socialLinks: ILink[];
}

export interface IPrefooterSection {
    title: string;
    twoColumns: boolean;
    items: ILink[];
}
