export interface ILink {
    name: string;
    url: string;
}

export type TRegion = ILink & {
    tld: string;
};

export interface ICommonData {
    secretKey: string;
    language: string;
    mordaHost: string;
    shareServices: string[];
    formsUrl: string;
}

export interface IEnumValue<T = string> {
    code: T;
    id: number;
    name: string;
    title: string;
    preposition?: string;
    namePrepositional?: string;
    estimate?: number;
}

export interface IGeoValue {
    geoId: number;
    id: number;
    name: string;
    preposition: string;
    namePrepositional: string;
    country?: {
        geoId: number;
        id: number;
        name: string;
        preposition: string;
        namePrepositional: string;
    };
}

export enum LoadingState {
    none = 'none',
    inProgress = 'inProgress',
    fail = 'fail',
    success = 'succes'
}
