import { IExtendedImage } from 'client/common/components/extended-image/ExtendedImage.type';

import { TCustomStyle } from 'utils/findCustomStyle';

import { IOpenGraph } from './meta';

export type TLevel =
    | ILevelMedia
    | ILevelQuote
    | ILevelDownload
    | ILevelAboutCompany
    | ILevelAgency
    | ILevelResults
    | ILevelResults2
    | ILevelMarkedText
    | ILevelMarkedText2
    | ILevelDataSummary
    | ILevelAdvice;

export interface IBaseLevel {
    type?: string;
    order?: number;
    title?: string;
    subtitle?: string;
    description?: string;
    og?: IOpenGraph;
    shareGoalId?: string;
    enabledTouchAdaptiveIframe?: boolean;
    customStyles: TCustomStyle[];
    compact?: boolean;
    compactOrder?: 'odd' | 'even';
}

export interface ILevelAboutCompany extends IBaseLevel {
    type: 'aboutCompany';
    blocks: Array<Record<'title' | 'text', string>>;
}

export interface ILevelMedia extends IBaseLevel {
    type: 'media';
    textAlign?: 'left' | 'right';
    contentDescription?: string;
    caption?: string;
    imageStyle?: {
        width: number;
        height: number;
    };
    blocks: TMediaBlock[];
}

export interface ILevelQuote extends IBaseLevel {
    type: 'quote';
    imageSrc: string;
    name: string;
    info: string;
    text: string;
}

export interface ILevelDownload extends IBaseLevel {
    type: 'download';
    contentTitle: string;
    contentDescription?: string;
    imageSrc: string;
    buttonText: string;
    buttonUrl: string;
}

export interface ILevelAgency extends IBaseLevel {
    type: 'agency';
    text: string;
    images: Array<Record<'imageSrc' | 'url', string>>;
}

export type TMediaBlock = Partial<{
    extendedImage?: IExtendedImage;
    image?: string;
    caption?: string;
    topText?: string;
    bottomText?: string;
}>;

export interface ILevelResults extends IBaseLevel {
    type: 'results';
    contentTitle: string;
    name: string;
    tag: string;
    results: IResult[];
    desktopHeight?: number;
    mobileHeight?: number;
}

export interface ILevelResults2 extends IBaseLevel {
    type: 'results2';
    contentTitle: string;
    companyTitle: string;
    footerText: string;
    tag: string;
    results: IResult[];
    rows: IDataRow[];
    mapItemsByRows: (results: IResult[], rows?: IDataRow[]) => IMappedResults[];
    desktopHeight?: number;
    mobileHeight?: number;
}

export interface IResult {
    title: string;
    imageSrc: string;
    description: string;
}

export interface IDataRow {
    key?: string;
    columns: number;
}

export interface IMappedResults {
    row: IDataRow;
    results: IResult[];
}

export interface ILevelCta extends IBaseLevel {
    type: 'cta';
    scrollEndGoalId?: string;
    blocks: ICtaBlock[];
}

export interface ILevelMarkedText extends IBaseLevel {
    type: 'markedText';
    text: string;
}

export interface ILevelMarkedText2 extends IBaseLevel {
    type: 'markedText2';
    title: string;
    textBefore: string;
    textAfter: string;
    texts: string[];
}

export interface ILevelVideo extends IBaseLevel {
    type: 'video';
    videoSrc: string;
    caption?: string;
}

export interface ICtaBlock {
    title: string;
    description?: string;
    buttonText: string;
    buttonUrl: string;
    metrikaGoalId?: string;
    formUrl?: string;
}

export interface ILevelSolutionRecommendations extends IBaseLevel {
    recommendations: string[];
}

export interface ILevelLikeYesNo extends IBaseLevel {
    type: 'likeYesNo';
    question: string;
    answerYes: ILikeAnswer;
    answerNo: ILikeAnswer;
    metrikaGoal: IMetrikaGoal;
}

export interface ILevelResumeLines extends IBaseLevel {
    image: string;
    lines: string[];
}

export interface ILevelAbstract extends IBaseLevel {
    type: 'abstract';
    body: string;
}

export interface ISolutionHeader extends IBaseLevel {
    type: 'solutionHeader';
    solutionTitle: string;
    solutionSubtitle: string;
    image: string;
}

export interface ILikeAnswer {
    text: string;
    imgGif: string;
    imgStill: string;
    reaction: string;
}

export interface IMetrikaGoal {
    id: string;
    paramSlug: string;
}

export interface IStructuredInfo extends IBaseLevel {
    type: 'structuredInfo';
    cards: ICardInformationBlock[];
    footer: string;
}

export interface ICardInformationBlock {
    image: string;
    title: string;
    items: string[];
}

export interface ILevelDataSummary extends IBaseLevel {
    type: 'dataSummary';
    summaryTitle: string;
    body: string;
    data: IDataItem[];
    footer?: string;
}

export interface IDataItem {
    title: string;
    description: string;
}

export interface ILevelAnnotatedImage extends IBaseLevel {
    type: 'annotatedImage';
    contentTitle?: string;
    body: string;
    image: string;
    imageCaption: string;
    imagePosition: string;
}
interface INote {
    title: string;
    subtitle: string;
    body: string;
}

export interface ILevelNote extends IBaseLevel {
    type: 'notes';
    notes: INote[];
}

export interface ILevelAdvice extends IBaseLevel {
    type: 'advice';
    body: string;
    image: string;
    compact: boolean;
}
