import { TCustomStyle } from 'utils/findCustomStyle';

import { IOpenGraph } from './meta';

type TSolutionKeys =
    | 'slug'
    | 'title'
    | 'description'
    | 'date'
    | 'image'
    | 'tasks'
    | 'industries'
    | 'products'
    | 'companySize'
    | 'changes'
    | 'periods'
    | 'shareText'
    | 'listImage'
    | 'theme'
    | 'cardType'
    | 'section'
    | 'topShareGoalId'
    | 'bottomShareGoalId';

export interface ISolution extends Record<TSolutionKeys, string> {
    enabled: boolean;
    important: boolean;
    listImageView: 'full' | 'top';
    og: IOpenGraph;
    imgTitle: string;
    logo: string;
    styleVersion: number;
    hideShare: boolean;
    customStyles: TCustomStyle[];
}

export interface ISolutionSection {
    title: string;
    text: string;
    og: IOpenGraph;
    tasks: IFilter[];
    products: IFilter[];
    industries: IFilter[];
    companySize: IFilter[];
    changes: IFilter[];
    periods: IFilter[];
    isDatesHidden: boolean;
}

export interface ISolutionsData {
    solution: ISolution;
    solutionSection: ISolutionSection;
    lastIdx: number;
    list: ISolution[];
    hasMore: TFiltersByCategory;
    solutionsPage: {
        title: string;
        text: string;
        tasks: IFilter[];
        products: IFilter[];
        industries: IFilter[];
        companySize: IFilter[];
        changes: IFilter[];
        periods: IFilter[];
        isDatesHidden: boolean;
    };
}

export interface IFilter {
    group?: string;
    name: string;
    slug: string;
}

export type TFiltersCategory =
    | 'tasks'
    | 'products'
    | 'industries'
    | 'companySize'
    | 'changes'
    | 'periods';

export type TFiltersByCategory = Record<TFiltersCategory, string[]>;
