import { IMetrikaOptions } from 'client/common/components/yandex-metrika';

import { IAgenciesConfig } from './agencies';
import { ICommonData } from './common';
import { IOpenGraph, ISeo } from './meta';

export interface IStatvalueCalculator {
    calculateButtonText: string;
    csvLinkText: string;
    pValueHint: string;
    pValueDefault: string;
    pValueText: string;
    kHint: string;
    kDefault: string;
    kText: string;
    excelLink: string;
    excelLinkText: string;

    columns: Record<string, string>;
}

export interface IStatvalueTextBlock {
    title: string;
    menuTitle: string;
    anchor: string;
    text: string;
}

export interface IStatvalueTexts {
    header: {
        buttonText: string;
        linkText: string;
    };
    title: {
        title: string;
        subtitle: string;
    };
    textBlocks: IStatvalueTextBlock[];
    form: {
        id: string;
        title: string;
    };
    toDirect: {
        buttonText: string;
        link: string;
        title: string;
    };
}

interface IStatvalueMetrika {
    id?: number;
    options: IMetrikaOptions;
}

interface IStatvalueSurvey {
    link: string;
    linkText: string;
    text: string;
    title: string;
}

export interface IDomain {
    href: string;
    language: string;
}

export interface IStatvalueAppData {
    basename: string;
    avatarsHost: string;
    calculator: IStatvalueCalculator;
    commonData: ICommonData;
    domains: Record<string, IDomain>;
    faviconUrl: string;
    homeUrl: string;
    htmlMappings: { [key: string]: string };
    language: string;
    metrika: IStatvalueMetrika;
    mordaHost: string;
    og?: IOpenGraph;
    passportHost: string;
    popup: boolean;
    published: boolean;
    seo?: ISeo;
    shareScript: string;
    survey: IStatvalueSurvey;
    texts: IStatvalueTexts;
    tld: string;
    url: string;
    uatraits: {
        isMobile: boolean
    };
    contactFormPath: string;
    secretKey: string;
    agenciesConfig: IAgenciesConfig;
}
