import React from 'react';

import Agency, { IAgencyProps } from 'client/common/components/agency';
import { useToggle } from 'client/common/hooks';

import { reachGoal } from 'utils/metrika';

import './index.css';

function DesktopAgency({ agency, agencyUrl, agenciesPageUrl, metrics }: IAgencyProps) {
    const {
        certificates,
        directCompanyType,
        isPartner,
        logo,
        name,
        offices,
        slug,
        productsInfo
    } = agency;

    const modalToggler = useToggle();

    function onButtonClick() {
        reachGoal('SVYAZ');

        modalToggler.switchOn();
    }

    return (
        <Agency agency={agency} agencyUrl={agencyUrl} agenciesPageUrl={agenciesPageUrl} metrics={metrics}>
            <Agency.Content>
                <Agency.Col>
                    <Agency.LeftColumn
                        certificates={certificates}
                        directCompanyType={directCompanyType}
                        isPartner={isPartner}
                        logo={logo}
                        offices={offices}
                        title={name}
                        metrics={metrics}
                        productsInfo={productsInfo}
                        />
                </Agency.Col>
                <Agency.Wrapper
                    agency={agency}
                    agencyUrl={agencyUrl}
                    onButtonClick={onButtonClick}
                    />
            </Agency.Content>
            <Agency.Modal
                agencySlug={slug}
                visible={modalToggler.value}
                handleClose={modalToggler.switchOff}
                />
        </Agency>
    );
}

export default DesktopAgency;
