import React, { DetailedHTMLProps, HTMLAttributes } from 'react';

import cn from 'utils/cn';

import 'client/common/components/html-content/index.css';
import './index.css';

interface IHtmlContentProps extends DetailedHTMLProps<
    HTMLAttributes<HTMLDivElement>,
    HTMLDivElement
> {
    className?: string;
    content?: string;
    tag?: string;
    theme?: string;
    enabledTouchAdaptiveIframe?: boolean;
}

const b = cn('html-content');

function HtmlContent({
    tag: TagName = 'div',
    theme = 'default',
    content,
    className,
    ...props
}: IHtmlContentProps) {
    return (
        <TagName
            // @ts-ignore
            className={b({ theme }, [className])}
            dangerouslySetInnerHTML={{ __html: content }}
            {...props}
            />
    );
}

export default HtmlContent;
