import { compose } from '@bem-react/core';
import { Registry, withRegistry } from '@bem-react/di';
import {
    Button as BaseButton,
    withSizeM as withButtonSizeM,
    withThemeNormal
} from '@yandex-lego/components/Button/desktop';
import {
    Icon as BaseIcon,
    withGlyphCaretsV,
    withTypeArrow
} from '@yandex-lego/components/Icon/desktop';
import {
    Menu as BaseMenu,
    withSizeM as withMenuSizeM,
    withThemeNormal as withMenuThemeNormal
} from '@yandex-lego/components/Menu/desktop';
import {
    Popup as BasePopup,
    withTargetAnchor,
    withThemeNormal as withPopupThemeNormal,
    withViewDefault as withPopupViewDefault
} from '@yandex-lego/components/Popup/desktop';
import { cnSelect, Select as BaseSelect } from '@yandex-lego/components/Select/desktop';
import { withOutsideClick } from '@yandex-lego/components/withOutsideClick';
import { withTogglable } from '@yandex-lego/components/withTogglable';

import { withDefaultSelectScope } from 'client/common/hooks';

import 'client/common/components/lego/select/index.css';

const Icon = compose(
    withTypeArrow,
    withGlyphCaretsV
)(BaseIcon);

const Button = compose(
    withButtonSizeM,
    withThemeNormal
)(BaseButton);

const Popup = compose(
    withPopupViewDefault,
    withOutsideClick,
    withTargetAnchor,
    withPopupThemeNormal
)(BasePopup);

const Menu = compose(
    withMenuThemeNormal,
    withMenuSizeM
)(BaseMenu);

const selectRegistry = new Registry({ id: cnSelect() });

selectRegistry
    .set('Trigger', Button)
    .set('Popup', Popup)
    .set('Menu', Menu)
    .set('Icon', Icon);

const Select = compose(
    withRegistry(selectRegistry),
    withTogglable
)(BaseSelect);

export default withDefaultSelectScope(Select) as typeof Select;
