import React from 'react';

import { ILevelProps } from 'client/common/components/level';
import {
    LevelTypeResults2,
    withLevelTypeResults2 as baseWithLevelTypeResults2
} from 'client/common/components/level/_type/level_type_results2';
import { IDataRow, IMappedResults, IResult } from 'client/common/types';

import './level_type_results2.css';

function getNextRow(rows: IDataRow[] | undefined, index: number): IMappedResults {
    if (rows && rows.length > index) {

        return {
            row: rows[index],
            results: []
        };
    }

    return {
        row: {
            columns: 0
        },
        results: []
    };
}

function mapItemsByRows(results: IResult[], rows?: IDataRow[]) {
    let rowIndex = -1;
    const mappedResults = [];
    let currentRow: IMappedResults | undefined;
    let columnsLeft: number = 0;
    let resultsLeft: number = results.length;

    for (const result of results) {
        if (!currentRow || !columnsLeft) {
            rowIndex += 1;
            currentRow = getNextRow(rows, rowIndex);
            currentRow.row.key = rowIndex.toString();
            columnsLeft = currentRow.row.columns || resultsLeft;
            mappedResults.push(currentRow);
        }

        currentRow.results.push(result);
        columnsLeft -= 1;
        resultsLeft -= 1;
    }

    return mappedResults;
}

export const withLevelTypeResults2 = baseWithLevelTypeResults2(
    (BaseLevel: React.FC<ILevelProps>) => props => {

        return (
            <LevelTypeResults2
                {...props}
                mapItemsByRows={mapItemsByRows}
                BaseLevel={BaseLevel}
                />
        );
    });
