import React from 'react';

import Prefooter, { cnPrefooter, IPrefooterProps } from 'client/common/components/prefooter';
import PrefooterItem from 'client/common/components/prefooter/item';
import { IPrefooterSection } from 'client/common/types';
import { splitIntoTwoArrays } from 'utils/helper';

import './index.css';

function DesktopPrefooter({ sections: prefooterSections }: Pick<IPrefooterProps, 'sections'>) {
    const columnKeys = ['left', 'right'];

    function mapColumn(col: JSX.Element[], index: number) {
        return (
            <div key={columnKeys[index]} className={cnPrefooter('col')}>
                {col}
            </div>
        );
    }

    function renderSections(sections: IPrefooterSection[]) {
        return sections.map(({ title, twoColumns, items }) => {
            const prefooterItems = items.map(({ url, name }) =>
                <PrefooterItem key={name} url={url} name={name} />);

            return (
                <div key={title} className={cnPrefooter('column')}>
                    <h4 className={cnPrefooter('title')}>{title}</h4>
                    {
                        twoColumns
                            ? splitIntoTwoArrays(prefooterItems).map(mapColumn)
                            : prefooterItems
                    }
                </div>
            );
        });
    }

    return <Prefooter sections={prefooterSections} renderSections={renderSections} />;
}

export default DesktopPrefooter;
