import { withBemMod } from '@bem-react/core';
import React, {
    ChangeEventHandler,
    Component,
    createRef,
    FormEvent,
    KeyboardEventHandler,
    MouseEvent,
    MouseEventHandler
} from 'react';

import { b, ISearchProps } from 'client/common/components/search';

import './search_type_menu.css';

export interface ISearchTypeMenuProps {
    type?: 'menu';
}

interface ISearchTypeMenuState {
    text: string;
    hidden: boolean;
}

export const withSearchTypeMenu = withBemMod<ISearchTypeMenuProps, ISearchProps>(
    b(),
    { type: 'menu' },
    BaseSearch => {
        return class extends Component<ISearchProps, ISearchTypeMenuState> {
            state = {
                text: '',
                hidden: true
            };

            inputRef = createRef<HTMLInputElement>();

            onBlur = () => this.hideInput();

            preventDefault = (event: FormEvent | MouseEvent) => event.preventDefault();

            focusOnInput = () => this.inputRef.current!.focus();

            hideInput = () => this.setState({ hidden: true });

            changeLocation = () => {
                const { text } = this.state;

                const encodedValue = encodeURIComponent(text);

                window.location.assign(`${this.props.siteSearchUrl}&text=${encodedValue}`);
            }

            onInputChange: ChangeEventHandler<HTMLInputElement> = event => {
                const input = event.target;
                const text = input.value;

                this.setState({ text });
            }

            onClick: MouseEventHandler = event => {
                event.preventDefault();

                const { text, hidden } = this.state;

                if (hidden) {
                    return this.setState({ hidden: false }, this.focusOnInput);
                }

                if (text.length) {
                    this.changeLocation();
                }
            }

            onKeyDown: KeyboardEventHandler = event => {
                if (event.key === 'Escape') {
                    this.hideInput();
                }
            }

            render() {
                const { className } = this.props;
                const { text, hidden } = this.state;

                return (
                    <BaseSearch
                        className={className}
                        hidden={hidden}
                        value={text}
                        controlRef={this.inputRef}
                        onKeyDown={this.onKeyDown}
                        onChange={this.onInputChange}
                        onBlur={this.onBlur}
                        onSubmit={this.preventDefault}
                        addonBefore={(
                            <button
                                type="submit"
                                className={b('button')}
                                onMouseDown={this.preventDefault}
                                onClick={this.onClick}
                                />
                        )}
                        />
                );
            }
        };
    });
