import React, { ComponentType } from 'react';
import { hydrate } from 'react-dom';
import { BrowserRouter, Route } from 'react-router-dom';
import { QueryParamProvider } from 'use-query-params';

interface IInitData {
    basename: string;
}

interface ICommonAppProps<Data extends IInitData, State> {
    data: Data;
    state: State;
}

export function createInitializer<Data extends IInitData, State>(
    App: ComponentType<ICommonAppProps<Data, State>>
) {
    return function init(data: Data, state: State) {
        hydrate(
            <BrowserRouter basename={data.basename}>
                <QueryParamProvider ReactRouterRoute={Route}>
                    <App data={data} state={state} />
                </QueryParamProvider>
            </BrowserRouter>,
            document.getElementById('mount')
        );
    };
}
