import HtmlContent from 'client/platforms/desktop/components/html-content';
import React, { useState } from 'react';
import Helmet from 'react-helmet';

import 'client/common/styles/fonts.css';
import cn from 'utils/cn';

import { IPostcardAppData } from 'client/common/types';

import { Circles } from '../circles';
import { Confetti } from '../confetti';
import { FallingFigures } from '../falling-figures';
import { Lines } from '../lines';

import './index.css';

interface IPostcardAppProps {
    data: IPostcardAppData;
}
/* eslint-disable complexity */
export function App({ data }: IPostcardAppProps) {
    const {
        faviconUrl,
        content
    } = data;

    const [showVertical, setShowVertical] = useState(false);

    const currentContent = content;

    const currentText = currentContent.text;

    const currentStyle = showVertical ? currentContent.verticalView : currentContent.horizontalView;
    const b = showVertical ? cn(`vertical_${currentContent.template}`) : cn(`horizontal_${currentContent.template}`);

    if (typeof window !== 'undefined') {

        window.addEventListener('resize', reportWindowSize);
        window.addEventListener('load', reportWindowSize);

        document.getElementsByTagName('html')[0].setAttribute('class', currentContent.template);
    }

    function reportWindowSize() {
        const currentShowVertical = window.innerHeight > window.innerWidth;

        if (currentShowVertical !== showVertical) {
            setShowVertical(currentShowVertical);
        }
    }

    return (
        <React.Fragment>
            <Helmet>
                <link rel="shortcut icon" href={faviconUrl} />
                <title>Яндекс открытка</title>
                <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover, minimum-scale=1, maximum-scale=1, user-scalable=no" />
                <meta name="format-detection" content="telephone=no" />
                <meta name="mobile-web-app-capable" content="yes" />

            </Helmet>
            {
                typeof window !== 'undefined' &&
                <>
                    <div className={`base-decoration ${b('decoration')}`}>
                        {currentContent.template === 'confetti' && <Confetti />}
                        {currentContent.template === 'circles' && <Circles />}
                        {currentContent.template === 'falling_figures' && <FallingFigures />}
                        {currentContent.template === 'lines' && <Lines />}
                    </div>
                    { typeof currentStyle !== 'string' && currentStyle?.background &&
                    <img src={currentStyle.background} className={`base-background ${b('background')}`} /> }
                    <div id="postcard" className={`base-main-wrapper ${b('main-wrapper')}`}>
                        { typeof currentText === 'string' && <HtmlContent className={b('text')} content={currentText} /> }
                        <img className={b('logo')} src={currentContent.logo} />
                    </div>
                </>
            }
        </React.Fragment>
    );

}
