import React, { useState } from 'react';
import cn from 'utils/cn';

import '../app/circles.css';

import './horizontal-circles.css';
import './vertical-circles.css';

export function Circles() {
    const [showVertical, setShowVertical] = useState(false);

    if (typeof window !== 'undefined') {
        window.addEventListener('resize', reportWindowSize);
        window.addEventListener('load', reportWindowSize);
    }

    function reportWindowSize() {
        const currentShowVertical = window.innerHeight > window.innerWidth;

        if (currentShowVertical !== showVertical) {
            setShowVertical(currentShowVertical);
        }
    }

    if (showVertical) {
        return (
            <CirclesVertical />
        );
    }

    return (
        <CirclesHorizontal />
    );
}

function CirclesHorizontal() {
    const b = cn(`horizontal-circles`);

    return (
        <div className={b('')}>
            <div className={b('big')} />
            <div className={b('small')} />
            <div className={b('extra-small')} />
        </div>
    );
}

function CirclesVertical() {
    const b = cn(`vertical-circles`);

    return (
        <div className={b('')}>
            <div className={b('big')} />
            <div className={b('small')} />
            <div className={b('extra-small')} />
        </div>
    );
}
