import React, { useState } from 'react';
import cn from 'utils/cn';

import '../app/confetti.css';

import './horizontal-confetti.css';
import './vertical-confetti.css';

export function Confetti() {
    const [showVertical, setShowVertical] = useState(false);

    if (typeof window !== 'undefined') {
        window.addEventListener('resize', reportWindowSize);
        window.addEventListener('load', reportWindowSize);
    }

    function reportWindowSize() {
        const currentShowVertical = window.innerHeight > window.innerWidth;

        if (currentShowVertical !== showVertical) {
            setShowVertical(currentShowVertical);
        }
    }

    if (showVertical) {
        return (
            <ConfettiVertical />
        );
    }

    return (
        <ConfettiHorizontal />
    );
}

function ConfettiHorizontal() {
    const b = cn(`horizontal-confetti`);

    return (
        <div className={b('')}>
            <div className={b('yellow')} />
            <div className={b('yellow-blur')} />
            <div className={b('pink')} />
            <div className={b('blue-blur')} />
            <div className={b('red')} />
            <div className={b('pink-blur')} />
            <div className={b('red-blur')} />
            <div className={b('blue')} />
            <div className={b('blue')} />
            <div className={b('red-blur')} />
            <div className={b('yellow-blur')} />
            <div className={b('blue-blur')} />
            <div className={b('blue')} />
        </div>
    );
}

function ConfettiVertical() {
    const b = cn(`vertical-confetti`);

    return (
        <div className={b('')}>
            <div className={b('yellow')} />
            <div className={b('yellow-blur')} />
            <div className={b('pink')} />
            <div className={b('blue-blur')} />
            <div className={b('red')} />
            <div className={b('pink-blur')} />
            <div className={b('red-blur')} />
            <div className={b('blue')} />
            <div className={b('blue')} />
            <div className={b('red-blur')} />
            <div className={b('yellow-blur')} />
            <div className={b('pink')} />
            <div className={b('blue-blur')} />
            <div className={b('blue')} />
        </div>
    );
}
