import React, { useState } from 'react';

import cn from 'utils/cn';

import '../app/falling_figures.css';

import './horizontal-falling-figures.css';
import './vertical-falling-figures.css';

export function FallingFigures() {
    const [showVertical, setShowVertical] = useState(false);

    if (typeof window !== 'undefined') {
        window.addEventListener('resize', reportWindowSize);
        window.addEventListener('load', reportWindowSize);
    }

    function reportWindowSize() {
        const currentShowVertical = window.innerHeight > window.innerWidth;

        if (currentShowVertical !== showVertical) {
            setShowVertical(currentShowVertical);
        }
    }

    if (showVertical) {
        return (
            <FallingFiguresVertical />
        );
    }

    return (
        <FallingFiguresHorizontal />
    );
}

function FallingFiguresHorizontal() {
    const b = cn(`horizontal-falling-figures`);

    return (
        <div className={b('')} >
            <img className={b('video')} src="https://avatars.mds.yandex.net/get-adv/995572/2a0000018018991b189a0294715c55a825e5/orig" alt="" />
        </div>
    );
}

function FallingFiguresVertical() {
    const b = cn(`vertical-falling-figures`);

    return (
        <div className={b('')} >
            <img className={b('video')} src="https://avatars.mds.yandex.net/get-adv/995572/2a00000180189a8ac66495ebac82a5c53bb0/orig" alt="" />
        </div>
    );
}
