import React from 'react';
import Helmet from 'react-helmet';

import { IMetrikaOptions, YMInitializer } from 'client/common/components/yandex-metrika';

import './index.css';

interface IMetrika {
    id: string;
    tls: string[];
    params: {
        webvisor: boolean;
    };
}

export interface IHeader {
    tag: string;
    attrs?: string;
    value?: string;
}

export interface IPromoProps {
    data: {
        metrikaCounters: IMetrika[];
        metrikaCountersParams: {
            clickmap: boolean;
            trackLinks: boolean;
            accurateTrackBounce: boolean;
        };
        faviconUrl: string;
        headers?: IHeader[];
        frameSrc?: string;
        basename: string;
        customFavicon?: string;
    };
}

export function App({ data }: IPromoProps) {

    const {
        metrikaCounters,
        metrikaCountersParams,
        faviconUrl,
        headers,
        frameSrc,
        customFavicon
    } = data;

    const customFaviconFullUrl = customFavicon && `${frameSrc}${customFavicon}`;

    return (
        <React.Fragment>
            <Helmet>
                <link rel="shortcut icon" href={customFaviconFullUrl || faviconUrl} key="favicon" />
                {
                    headers && headers.map((header, i) => {
                        const attrs = {
                            ...header.attrs && JSON.parse(header.attrs),
                            key: i.toString()
                        };

                        return React.createElement(header.tag, attrs, header.value);
                    })
                }
            </Helmet>
            {
                frameSrc &&
                    <div id="content">
                        <iframe
                            width="100%"
                            height="100%"
                            frameBorder="0"
                            src={frameSrc}
                            sandbox="allow-scripts allow-same-origin allow-popups allow-presentation allow-popups-to-escape-sandbox"
                            />
                    </div>
            }
            <YMInitializer
                accounts={metrikaCounters.map(counter => Number(counter.id))}
                options={prepareMetikaOptions()}
                />
        </React.Fragment>
    );

    function prepareMetikaOptions() {
        return metrikaCounters.reduce((acc: IMetrikaOptions, counter) => {
            acc[counter.id] = { ...metrikaCountersParams, ...counter.params };

            return acc;
        }, {});
    }
}
