import { classnames } from '@bem-react/classnames';
import React from 'react';

import cn from 'utils/cn';

import FormIframe from 'client/common/components/form-iframe';
import { useCommonData } from 'client/common/hooks';

import './index.css';

const b = cn('access-request');

interface IAccessRequestProps {
    className?: string;
    formId: string;
    title: string;
}

export function AccessRequest({ className = '', formId, title }: IAccessRequestProps) {
    const { formsUrl } = useCommonData();

    const formSrc = `${formsUrl}/${formId}/`;
    const query = { theme: 'constructor-default' };

    return (
        <div className={classnames(b(), className)}>
            <div className={b('wrapper')}>
                <div
                    id="access-request"
                    className={b('title')}
                    dangerouslySetInnerHTML={{ __html: title }}
                    />
                <FormIframe
                    adaptive
                    initialHeight="600px"
                    className={b('form')}
                    src={formSrc}
                    query={query}
                    />
            </div>
        </div>
    );
}
