import React from 'react';

import cn from 'utils/cn';
import { reachGoal } from 'utils/metrika';

import { useCommonData } from 'client/common/hooks';

import Copyright from 'client/common/components/lego/copyright';
import YaShare from 'client/common/components/ya-share';

import './index.css';

const b = cn('footer');

export function Footer() {
    const { shareServices } = useCommonData();

    function handleShare(serviceName: string) {
        reachGoal('share-block', { serviceName });
    }

    return (
        <footer className={b()}>
            <div className={b('wrapper')}>
                <YaShare
                    bare={false}
                    id="share-footer"
                    size="m"
                    className={b('share')}
                    services={shareServices.join(',')}
                    onShare={handleShare}
                    />
                <Copyright />
            </div>
        </footer>
    );
}
