import React from 'react';

import cn from 'utils/cn';

import { useCommonData } from 'client/common/hooks';
import { IDomain, IStatvalueTextBlock } from 'client/common/types';

import Logo from 'client/common/components/logo';
import { Button } from 'client/platforms/statvalue/components/lego';
import TldSwitcher from 'client/platforms/statvalue/components/tld-switcher';

import './index.css';

const b = cn('header');

interface IHeaderProps {
    className?: string;
    buttonText: string;
    domains: Record<string, IDomain>;
    linkText: string;
    published: boolean;
    textBlocks: IStatvalueTextBlock[];
    tld: string;
}

export function Header({ className, buttonText, domains, linkText, published, textBlocks, tld }: IHeaderProps) {
    const { language, mordaHost } = useCommonData();

    return (
        <header className={b({}, [className])}>
            <div className={b('wrapper')}>
                <Logo colored service="direct" language={language} url={mordaHost} />
                <div className={b('links')}>
                    <a className={b('link')} href="#calculator">{linkText}</a>
                    {textBlocks
                        .filter(({ anchor, menuTitle }) => anchor && menuTitle)
                        .map(({ anchor, menuTitle }) => (
                            <a key={anchor} className={b('link')} href={`#${anchor}`}>
                                {menuTitle}
                            </a>
                        ))
                    }
                    <TldSwitcher domains={domains} tld={tld} />
                    {!published && buttonText && (
                        <Button
                            size="l"
                            theme="normal"
                            type="link"
                            url="#access-request"
                            >
                            {buttonText}
                        </Button>
                    )}
                </div>
            </div>
        </header>
    );
}
