import { classnames } from '@bem-react/classnames';
import React, { useRef, useState } from 'react';

import cn from 'utils/cn';

import { Popup } from 'client/platforms/statvalue/components/lego';

import './index.css';

const b = cn('hint');

interface IHintProps {
    className?: string;
    text: string;
}

export function Hint({ className = '', text }: IHintProps) {
    const rootRef = useRef<HTMLDivElement>(null);
    const [isVisible, setIsVisible] = useState(false);

    function handleClick() {
        setIsVisible(true);
    }

    function handleOutsideClick() {
        setIsVisible(false);
    }

    return (
        <div className={classnames(b(), className)} ref={rootRef} onClick={handleClick}>
            <Popup
                autoclosable
                hasTail
                target="anchor"
                theme="normal"
                view="default"
                mainOffset={15}
                anchor={rootRef.current}
                visible={isVisible}
                onOutsideClick={handleOutsideClick}
                >
                <div className={b('text')} dangerouslySetInnerHTML={{ __html: text }} />
            </Popup>
        </div>
    );
}
