import { IStatvalueCalculator } from 'client/common/types';

export interface IColumn {
    editable?: boolean;
    hideOnA?: boolean;
    hintText?: string;
    id: string;
    suffix?: string;
    title: string;
    width?: number;
    paddings?: number;
    getValue?(segment: ISegment, index: number): number | string;
    getMods?(segment: ISegment, index: number): Record<string, boolean | string>;
    getTitle?(segment: ISegment, index: number): string;
}

export interface ISegment {
    size: string;
    cost: string;
    conversions: string;
    clicks: string;

    [key: string]: string | undefined;
}

export interface ISegmentsProps {
    calculator: IStatvalueCalculator;
    className?: string;
    onCalculate(): void;
}

export interface ISegmentsState {
    pValueTarget: string;
    k: string;
    segments: ISegment[];
    hasResults: boolean;
    pristine: boolean;
    hoveredSegment: number;
}

export enum ActionType {
    AddSegment,
    SetResults,
    SetSegmentField,
    SetPValueTarget,
    SetK,
    RemoveSegment,
    SetHoveredSegment
}

interface IAddSegmentAction {
    type: ActionType.AddSegment;
}

interface ISetResultsAction {
    type: ActionType.SetResults;
    payload: ISegment[];
}

interface ISetSegmentFieldAction {
    type: ActionType.SetSegmentField;
    payload: {
        index: number;
        value: string;
        id: string;
    };
}

interface ISetPValueAction {
    type: ActionType.SetPValueTarget;
    payload: string;
}

interface ISetKAction {
    type: ActionType.SetK;
    payload: string;
}

interface IRemoveSegmentAction {
    type: ActionType.RemoveSegment;
    payload: number;
}

interface ISetHoveredSegmentAction {
    type: ActionType.SetHoveredSegment;
    payload: number;
}

export type TAction =
    | IAddSegmentAction
    | ISetResultsAction
    | ISetSegmentFieldAction
    | ISetPValueAction
    | ISetKAction
    | IRemoveSegmentAction
    | ISetHoveredSegmentAction;
