import React, {
    MouseEvent,
    useEffect,
    useState
} from 'react';

import cn from 'utils/cn';
import { getCookie, setCookie } from 'utils/cookies';

import './index.css';

const b = cn('survey');
const cookie = 'yadv-hide-survey';

interface ISurveyProps {
    calculated: boolean;
    link: string;
    linkText: string;
    text: string;
    title: string;
}

export function Survey({ calculated, link, linkText, text, title }: ISurveyProps) {
    const [visible, setVisible] = useState(false);
    const [mounted, setMounted] = useState(false);

    function handleClose(event: MouseEvent<HTMLDivElement>) {
        event.preventDefault();

        setCookie(cookie, '1');
        setVisible(false);
    }

    function handleLinkClick() {
        setCookie(cookie, '1');
        setVisible(false);
    }

    useEffect(() => {
        if (!getCookie(cookie) && calculated) {
            setTimeout(() => {
                setVisible(true);
            }, 5000);
        }
    }, [calculated]);

    /**
     * Обходим баг в Chromium, при котором при инициализации страницы отрабатывают transition'ы
     * @see: https://crbug.com/332189
     */
    useEffect(() => {
        setMounted(true);
    }, []);

    return (
        <a
            rel="noopener noreferrer"
            target="_blank"
            className={b({ visible, mounted })}
            href={link}
            onClick={handleLinkClick}
            >
            <div className={b('close')} onClick={handleClose} />
            <div className={b('title')} dangerouslySetInnerHTML={{ __html: title }} />
            <div className={b('text')} dangerouslySetInnerHTML={{ __html: text }} />
            <div className={b('link')} dangerouslySetInnerHTML={{ __html: linkText }} />
        </a>
    );
}
