import { classnames } from '@bem-react/classnames';
import React from 'react';

import cn from 'utils/cn';

import './index.css';

const b = cn('text-block');

interface ITextBlockProps {
    text: string;
    className?: string;
    id?: string;
    title: string;
}

export function TextBlock({ className = '', id, text, title }: ITextBlockProps) {
    return (
        <div className={classnames(b(), className)}>
            <h2 id={id} className={b('title')} dangerouslySetInnerHTML={{ __html: title }} />
            <div className={b('content')} dangerouslySetInnerHTML={{ __html: text }} />
        </div>
    );
}
