import { classnames } from '@bem-react/classnames';
import React from 'react';

import cn from 'utils/cn';

import './index.css';

const b = cn('title');

interface ITitleProps {
    className?: string;
    title: string;
    subtitle: string;
}

export function Title({ className = '', title, subtitle }: ITitleProps) {
    return (
        <div className={classnames(b(), className)}>
            <h1 className={b('text')} dangerouslySetInnerHTML={{ __html: title }} />
            <div className={b('subtitle')} dangerouslySetInnerHTML={{ __html: subtitle }} />
        </div>
    );
}
