import { ItemSimple } from '@yandex-lego/components/Menu';
import React, { ChangeEvent } from 'react';

import { IDomain } from 'client/common/types/statvalue';
import { Select } from 'client/platforms/statvalue/components/lego';
import cn from 'utils/cn';

import './index.css';

export interface ITldSwitcherProps {
    domains: Record<string, IDomain>;
    tld: string;
}

const b = cn('tld-switcher');

export default function TldSwitcher({ domains, tld: currentTld }: ITldSwitcherProps) {
    function handleChange(tld: string) {
        window.location.href = domains[tld].href;
    }

    function handleChangeSelect(event: ChangeEvent<HTMLSelectElement>) {
        handleChange(event.target.value);
    }

    const tlds = Object.keys(domains).filter(tld => tld !== currentTld);

    if (tlds.length === 0) {
        return null;
    }

    if (tlds.length === 1) {
        return (
            <button className={b('button')} onClick={() => handleChange(tlds[0])}>
                {domains[currentTld].language}
            </button>
        );
    }

    const options = tlds.reduce((acc, tld) => ({
        ...acc,
        items: acc.items.concat({
            value: tld,
            content: <span key={tld} className={b('text')}>{domains[tld].language}</span>
        })
    }), { title: '', items: [] as ItemSimple[] });

    return (
        <div className={b()}>
            <Select
                size="m"
                theme="normal"
                placeholder={currentTld}
                onChange={handleChangeSelect}
                options={[options]}
                />
        </div>
    );
}
