import { classnames } from '@bem-react/classnames';
import React from 'react';

import cn from 'utils/cn';

import { Button } from 'client/platforms/statvalue/components/lego';

import './index.css';

const b = cn('to-direct');

interface IToDirectProps {
    className?: string;
    buttonText: string;
    link: string;
    title: string;
}

export function ToDirect({ className = '', buttonText, link, title }: IToDirectProps) {
    return (
        <div className={classnames(b(), className)}>
            <div className={b('wrapper')}>
                {title && (
                    <div
                        className={b('title')}
                        dangerouslySetInnerHTML={{ __html: title }}
                        />
                )}
                <Button
                    size="l"
                    target="_blank"
                    theme="normal"
                    type="link"
                    url={link}
                    >
                    {buttonText}
                </Button>
            </div>
        </div>
    );
}
