import React from 'react';

import Slider from 'react-slick';

import 'slick-carousel/slick/slick-theme.css';
import 'slick-carousel/slick/slick.css';

import { ICardContainerProps } from 'client/common/components/card-container/CardContainer.types';

const CardContainer = ({ children }: ICardContainerProps) => {
    const settings = {
        dots: true,
        infinite: true,
        speed: 300,
        slidesToShow: 1,
        variableWidth: true,
        adaptiveHeight: false,
        centerMode: true,
        centerPadding: '0px'
    };

    return (
        <Slider {...settings}>
            { children }
        </Slider>
    );
};

export default CardContainer;
