import React from 'react';

import Logo from 'client/common/components/logo';
import { useConfig, useLegoComponents } from 'client/common/hooks';
import cn from 'utils/cn';

import 'client/common/components/header';
import './index.css';

const b = cn('header');

function Header() {
    const { mordaHost, language } = useConfig();
    const { User } = useLegoComponents();

    return (
        <header className={b()}>
            <Logo className={b('logo')} language={language} url={mordaHost} />
            <div className={b('right-column')}>
                <User />
            </div>
        </header>
    );
}

export default Header;
