import React, { DetailedHTMLProps, HTMLAttributes, useEffect, useRef } from 'react';

import 'client/common/components/html-content/index.css';
import cn from 'utils/cn';
import './html-content.css';

interface IHtmlContentProps extends DetailedHTMLProps<
HTMLAttributes<HTMLDivElement>,
HTMLDivElement
>{
    content: string;
    className?: string;
    tag?: string;
    theme?: string;
    onRender?: (currentNode: HTMLDivElement) => void;
}

const b = cn('html-content');

function HtmlContent({
    tag: TagName = 'div',
    theme = 'default',
    content,
    className,
    onRender,
    ...props
}: IHtmlContentProps) {
    const nodeRef = useRef<HTMLDivElement>(null);

    useEffect(() => {
        if (onRender && nodeRef.current) {
            onRender(nodeRef.current);
        }
    }, [onRender]);

    return (
        <TagName
            // @ts-ignore
            className={b({ theme }, [className])}
            dangerouslySetInnerHTML={{ __html: content }}
            ref={nodeRef}
            {...props}
            />
    );
}

export default HtmlContent;
