import { Registry } from '@bem-react/di';

import Button from './button';
import Checkbox from './checkbox';
import Icon from './icon';
import Link from './link';
import Modal from './modal';
import Popup from './popup';
import Select from './select';
import Spin from './spin';
import Textinput from './text-input';
import Textarea from './textarea';
import User from './user';

const registry = new Registry({ id: 'lego' });

const components = {
    Button,
    Checkbox,
    Icon,
    Link,
    Modal,
    Popup,
    Select,
    Spin,
    Textarea,
    Textinput,
    User
};

for (const name of Object.keys(components)) {
    const component = (components as any)[name]; // tslint:disable-line:no-any

    registry.set(name, component);
}

export type IRegistry = typeof components;

export const legoRegistry = registry;
