import React from 'react';

import { ILevelProps } from 'client/common/components/level';
import {
    LevelTypeResults,
    withLevelTypeResults as baseWithLevelTypeResults
} from 'client/common/components/level/_type/level_type_results';

import './level_type_results.css';

export const withLevelTypeResults = baseWithLevelTypeResults(
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { mobileHeight, ...otherProps } = props;

        return (
            <LevelTypeResults
                {...otherProps}
                BaseLevel={BaseLevel}
                imageHeight={mobileHeight}
                />
        );
    });
