import React from 'react';

import { ILevelProps } from 'client/common/components/level';
import {
    LevelTypeResults2,
    withLevelTypeResults2 as baseWithLevelTypeResults2
} from 'client/common/components/level/_type/level_type_results2';
import { IMappedResults, IResult } from 'client/common/types';

import './level_type_results2.css';

function mapItemsByRows(results: IResult[]): IMappedResults[] {
    return [
        {
            row: {
                columns: 0
            },
            results
        }
    ];
}

export const withLevelTypeResults2 = baseWithLevelTypeResults2(
    (BaseLevel: React.FC<ILevelProps>) => props => {

        return (
            <LevelTypeResults2
                {...props}
                mapItemsByRows={mapItemsByRows}
                BaseLevel={BaseLevel}
                />
        );
    });
