import React from 'react';

import PrefooterItem from 'client/common/components/prefooter/item';

import Prefooter, { cnPrefooter, IPrefooterProps } from 'client/common/components/prefooter';
import { IPrefooterSection } from 'client/common/types';

import PrefooterToggle from './toggle';

import './index.css';

function TouchPhonePrefooter({ sections: prefooterSections }: Pick<IPrefooterProps, 'sections'>) {
    function renderSections(sections: IPrefooterSection[]) {
        return sections.map(({ title, items }) => (
            <React.Fragment key={title}>
                <PrefooterToggle title={title} />
                <div className={cnPrefooter('column')}>
                    {items.map(({ url, name }) =>
                        <PrefooterItem key={name} url={url} name={name} />)}
                </div>
            </React.Fragment>
        ));
    }

    return <Prefooter sections={prefooterSections} renderSections={renderSections} />;
}

export default TouchPhonePrefooter;
