import React, { Component } from 'react';

import { cnPrefooter } from 'client/common/components/prefooter';

interface IPrefooterToggleProps {
    title: string;
}

interface IPrefooterToggleState {
    isOpen: boolean;
}

class PrefooterToggle extends Component<IPrefooterToggleProps, IPrefooterToggleState> {
    state = {
        isOpen: false
    };

    render() {
        const { title } = this.props;
        const { isOpen } = this.state;

        const mod = isOpen ? { opened: 'yes' } : {};
        const cn = cnPrefooter('toggle', mod);

        return <div className={cn} onClick={this.onClick}>{title}</div>;
    }

    private onClick = () => this.setState({ isOpen: !this.state.isOpen });
}

export default PrefooterToggle;
