import { withBemMod } from '@bem-react/core';
import { ComponentRegistryConsumer } from '@bem-react/di';
import React, {
    ChangeEventHandler,
    Component,
    createRef,
    FormEvent, MouseEvent, MouseEventHandler
} from 'react';

import { b, ISearchProps } from 'client/common/components/search';
import i18n from 'utils/i18n';

export interface ISearchTypeSidebarProps {
    type?: 'sidebar';
}

interface ISearchTypeSidebarState {
    text: string;
}

export const withSearchTypeSidebar = withBemMod<ISearchTypeSidebarProps, ISearchProps>(
    b(),
    { type: 'sidebar' },
    BaseSearch => {
        return class extends Component<ISearchProps, ISearchTypeSidebarState> {
            state = {
                text: ''
            };

            inputRef = createRef<HTMLInputElement>();

            preventDefault = (event: FormEvent | MouseEvent) => event.preventDefault();

            changeLocation = () => {
                const { text } = this.state;

                const encodedValue = encodeURIComponent(text);

                window.location.assign(`${this.props.siteSearchUrl}&text=${encodedValue}`);
            }

            onInputChange: ChangeEventHandler<HTMLInputElement> = event => {
                const input = event.target;
                const text = input.value;

                this.setState({ text });
            }

            onClick: MouseEventHandler = event => {
                event.preventDefault();

                const { text } = this.state;

                if (text.length) {
                    this.changeLocation();
                }
            }

            render() {
                const { className } = this.props;
                const { text } = this.state;

                const buttonText = i18n({
                    keyset: 'search',
                    key: 'find'
                });

                const placeholderText = i18n({
                    keyset: 'search',
                    key: 'search'
                });

                return (
                    <ComponentRegistryConsumer id="lego">{({ Button }) => (
                        <BaseSearch
                            className={className}
                            value={text}
                            placeholder={placeholderText}
                            controlRef={this.inputRef}
                            onChange={this.onInputChange}
                            onSubmit={this.preventDefault}
                            addonInside={(
                                <Button
                                    className={b('button')}
                                    size="m"
                                    theme="normal"
                                    pin="clear-round"
                                    type="submit"
                                    onClick={this.onClick}
                                    >
                                    {buttonText}
                                </Button>
                            )}
                            />)}
                    </ComponentRegistryConsumer>
                );
            }
        };
    });
