import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';

import { IAppState } from 'store';
import { toggleSidebar } from 'store/sidebar/actions';
import { TSidebarAction } from 'store/sidebar/types';

import SidebarDimmer from './sidebar-dimmer';

interface IDispatchProps {
    toggleSidebar(): void;
}

interface IStateProps {
    active: boolean;
}

function mapStateToProps(state: IAppState): IStateProps {
    const { isOpen } = state.sidebar;

    return {
        active: isOpen
    };
}

function mapDispatchToProps(dispatch: Dispatch<TSidebarAction>): IDispatchProps {
    return bindActionCreators({
        toggleSidebar
    }, dispatch);
}

export default connect<IStateProps>(
    mapStateToProps,
    mapDispatchToProps
)(SidebarDimmer);
