import React, { Component, createRef } from 'react';

import { TSidebarAction } from 'store/sidebar/types';
import cn from 'utils/cn';

import './index.css';

const cnSidebarDimmer = cn('sidebar-dimmer');

interface ISidebarDimmerProps {
    active: boolean;
    toggleSidebar(): TSidebarAction;
}

class SidebarDimmer extends Component<ISidebarDimmerProps> {
    private readonly dimmerRef = createRef<HTMLDivElement>();

    // Подписываемся через addEventListener, чтобы выставить passive: false
    // Без этого нельзя сделать preventDefault
    componentDidMount() {
        const dimmerElement = this.dimmerRef.current;
        const options = { passive: false };

        if (dimmerElement) {
            dimmerElement.addEventListener('click', this.closeSidebar);

            dimmerElement.addEventListener('touchmove', this.preventDefault, options);
            dimmerElement.addEventListener('scroll', this.preventDefault, options);
        }
    }

    componentWillUnmount() {
        const dimmerElement = this.dimmerRef.current;

        if (dimmerElement) {
            dimmerElement.removeEventListener('click', this.closeSidebar);

            dimmerElement.removeEventListener('touchmove', this.preventDefault);
            dimmerElement.removeEventListener('scroll', this.preventDefault);
        }
    }

    closeSidebar = () => {
        this.props.toggleSidebar();
    }

    preventDefault = (event: Event) => {
        event.preventDefault();
    }

    render() {
        const { active } = this.props;
        const mod = active ? { active: 'yes' } : { active: 'no' };

        return (
            <div className={cnSidebarDimmer(mod)} ref={this.dimmerRef}>
                <div className={cnSidebarDimmer('close')} />
            </div>
        );
    }
}

export default SidebarDimmer;
