import { Registry, withRegistry } from '@bem-react/di';
import { hot } from 'react-hot-loader/root';
import { compose } from 'redux';

import AppCommon from 'client/common/components/app';

import { createInitializer } from 'client/platforms/init';

import AgenciesFilters from './components/agencies-filters';
import AgenciesList from './components/agencies-list';
import AgenciesListLink from './components/agencies-list-link';
import AgenciesTitle from './components/agencies-title';
import Agency from './components/agency';
import AgencyEstimate from './components/agency-estimate';
import AgencyForm from './components/agency-form';
import AgencyInfo from './components/agency-info';
import AgencyMaterials from './components/agency-materials';
import Card from './components/card';
import CardContainer from './components/card-container';
import CardInformation from './components/card-information';
import ExpandableText from './components/expandable-text';
import ExtendedImage from './components/extended-image';
import Footer from './components/footer';
import Header from './components/header';
import HtmlContent from './components/html-content';
import Level from './components/level';
import MainLayout from './components/main-layout';
import MainMenu from './components/main-menu';
import Media from './components/media';
import ModalContent from './components/modal-content';
import Offices from './components/offices';
import PlatformWrapper from './components/platform-wrapper';
import Prefooter from './components/prefooter';
import ProductsInfoCard from './components/products-info-card';
import Search from './components/search';
import Sidebar from './components/sidebar';
import SidebarDimmer from './components/sidebar-dimmer';
import SidebarPusher from './components/sidebar-pusher';
import SolutionHeader from './components/solution-header/SolutionHeader';
import UnderscoredInput from './components/underscored-input';
import VideoIframe from './components/video-iframe';
import YaShare from './components/ya-share';
import ZoomableImage from './components/zoomable-image';

import AgenciesPage from './pages/agencies';
import AgencyPage from './pages/agency';
import SolutionPage from './pages/solution';
import SolutionsPage from './pages/solutions';

import { legoRegistry } from './components/lego/registry';

const registry = new Registry({ id: 'app' });

const components = {
    AgenciesFilters,
    AgenciesList,
    AgenciesListLink,
    AgenciesTitle,
    Agency,
    AgencyEstimate,
    AgencyForm,
    AgencyInfo,
    AgencyMaterials,
    Card,
    CardContainer,
    CardInformation,
    ExpandableText,
    ExtendedImage,
    ZoomableImage,
    Footer,
    Header,
    HtmlContent,
    Level,
    MainLayout,
    MainMenu,
    Media,
    ModalContent,
    Offices,
    Prefooter,
    PlatformWrapper,
    ProductsInfoCard,
    Search,
    Sidebar,
    SidebarDimmer,
    SidebarPusher,
    SolutionHeader,
    UnderscoredInput,
    VideoIframe,
    YaShare,

    AgencyPage,
    AgenciesPage,
    SolutionPage,
    SolutionsPage
};

for (const name of Object.keys(components)) {
    const component = (components as any)[name]; // tslint:disable-line:no-any

    registry.set(name, component);
}

export type IRegistry = typeof components;

export const App = compose(
    hot,
    withRegistry(registry, legoRegistry)
)(AppCommon);
export const init = createInitializer(App);
