const { writeFileSync } = require('fs');
const { join } = require('path');

const { xmlToJs } = require('./tanker');

const i18n = require('../../tmp/advertising-www');

const langs = Object.keys(i18n);

for (const lang of langs) {
    let fileContent = [
        '// @ts-ignore',
        `import * as dynamic from './dynamic/i18n.${lang}';`,
        'import { ITranslations } from \'./types\';',
        '',
        'const i18n: ITranslations = {};'
    ];

    const keysets = Object.keys(i18n[lang]);

    for (const keyset of keysets) {
        fileContent.push(`i18n['${keyset}'] = {};`);

        const keys = Object.keys(i18n[lang][keyset]);

        for (const key of keys) {
            let parsedString = xmlToJs(i18n[lang][keyset][key]);

            fileContent.push(`i18n['${keyset}']['${key}'] = ${parsedString};`);
        }
    }
    fileContent.push('', 'export default i18n;');

    fileContent = fileContent.join('\n');
    const filePath = join(__dirname, '..', '..', 'utils', 'i18n', `i18n.${lang}.ts`);

    writeFileSync(filePath, fileContent, 'utf-8');
}
