import { TGroup } from 'client/common/types';

import {
    ActionTypes,
    IAgenciesFilter,
    IFinishLoadingPayload,
    TAgenciesFilters,
    TBudget,
    TBudgetOrder,
    TMultiValueFilterId,
    TSingleValueFilterId
} from './types';

export function addMultiFilter(filterId: TMultiValueFilterId, optionId: string) {
    return { type: ActionTypes.ADD_MULTI_FILTER, payload: { filterId, optionId } };
}

export function replaceMultiFilter(filterId: TMultiValueFilterId, index: number, optionId: string) {
    return { type: ActionTypes.REPLACE_MULTI_FILTER, payload: { filterId, index, optionId } };
}

export function removeMultiFilter(filterId: TMultiValueFilterId, optionId: string) {
    return { type: ActionTypes.REMOVE_MULTI_FILTER, payload: { filterId, optionId } };
}

export function changeSingleFilter(filterId: TSingleValueFilterId, value: string, relatedFilter?: IAgenciesFilter) {
    return { type: ActionTypes.CHANGE_SINGLE_FILTER, payload: { filterId, value, relatedFilter } };
}

export function resetFilters(filters: TAgenciesFilters) {
    return { type: ActionTypes.RESET_FILTERS, payload: { filters } };
}

export function setBudget(budget: TBudget) {
    return { type: ActionTypes.SET_BUDGET, payload: { budget } };
}

export function setBudgetOrder(budgetOrder: TBudgetOrder) {
    return { type: ActionTypes.SET_BUDGET_ORDER, payload: { budgetOrder } };
}

export function startLoading(group: TGroup) {
    return { type: ActionTypes.START_LOADING, payload: { group } };
}

export function startLoadingFromScratch(group: TGroup) {
    return { type: ActionTypes.START_LOADING_FROM_SCRATCH, payload: { group } };
}

export function finishLoading({ agencies, group, hasMore }: IFinishLoadingPayload) {
    return { type: ActionTypes.FINISH_LOADING, payload: { agencies, group, hasMore } };
}

export function failLoading(group: TGroup) {
    return { type: ActionTypes.FAIL_LOADING, payload: { group } };
}
