import { Action } from 'redux-actions';

import {
    IAgenciesFilters,
    IAgenciesLists,
    IAgency,
    TGroup
} from 'client/common/types';

export type TMultiValueFilterId =
    | 'city'
    | 'certificate'
    | 'service';

export type TSingleValueFilterId =
    | 'country'
    | 'budget'
    | 'budgetOrder';

export type TFilterId = TMultiValueFilterId | TSingleValueFilterId;

export type TMultiValueFilters = {
    [id in TMultiValueFilterId]: string[];
};

export type TSingleValueFilters = {
    [id in TSingleValueFilterId]?: string;
};

export interface IAgenciesFilter {
    filterId: TFilterId;
    value: string | string[];
}

export type TAgenciesFilters = TMultiValueFilters & TSingleValueFilters;

export type TBudget = string | undefined;
export type TBudgetOrder = string | undefined;

export interface IAgenciesState {
    filters: TAgenciesFilters;
    rawFilters: IAgenciesFilters;
    lists: IAgenciesLists;
    isError: boolean;
}

export enum ActionTypes {
    ADD_MULTI_FILTER = '[agencies] add multiple value filter',
    REPLACE_MULTI_FILTER = '[agencies] replace multiple value filter',
    REMOVE_MULTI_FILTER = '[agencies] remove multiple value filter',
    CHANGE_SINGLE_FILTER = '[agencies] change single value filter',
    RESET_FILTERS = '[agencies] reset filters',
    SET_BUDGET = '[agencies] set budget',
    SET_BUDGET_ORDER = '[agencies] set budget order',
    START_LOADING = '[agencies] start loading',
    START_LOADING_FROM_SCRATCH = '[agencies] start loading from scratch',
    FINISH_LOADING = '[agencies] finish loading',
    FAIL_LOADING = '[agencies] fail loading'
}

export interface IAddMultiFilterPayload {
    filterId: TMultiValueFilterId;
    optionId: string;
}

export interface IReplaceMultiFilterPayload {
    filterId: TMultiValueFilterId;
    index: number;
    optionId: string;
}

export interface IRemoveMultiFilterPayload {
    filterId: TMultiValueFilterId;
    optionId: string;
}

export interface IChangeSingleFilterPayload {
    filterId: TSingleValueFilterId;
    value: string;
    relatedFilter: IAgenciesFilter;
}

export interface IResetFiltersPayload {
    filters: TAgenciesFilters;
}

export interface ISetBudgetPayload {
    budget?: string;
}

export interface ISetBudgetOrderPayload {
    budgetOrder?: TBudgetOrder;
}

export interface IStartLoadingPayload {
    group: TGroup;
}

export interface IFailLoadingPayload {
    group: TGroup;
}

export interface IFinishLoadingPayload {
    group: TGroup;
    agencies: IAgency[];
    hasMore: boolean;
}

export interface IAddMultiFilterAction extends Action<IAddMultiFilterPayload> {
    type: ActionTypes.ADD_MULTI_FILTER;
}

export interface IReplaceMultiFilterAction extends Action<IReplaceMultiFilterPayload> {
    type: ActionTypes.REPLACE_MULTI_FILTER;
}

export interface IRemoveMultiFilterAction extends Action<IRemoveMultiFilterPayload> {
    type: ActionTypes.REMOVE_MULTI_FILTER;
}

export interface IChangeSingleFilterAction extends Action<IChangeSingleFilterPayload> {
    type: ActionTypes.CHANGE_SINGLE_FILTER;
}

export interface IResetFiltersAction extends Action<IResetFiltersPayload> {
    type: ActionTypes.RESET_FILTERS;
}

export interface ISetBudgetAction extends Action<ISetBudgetPayload> {
    type: ActionTypes.SET_BUDGET;
}

export interface ISetBudgetOrderAction extends Action<ISetBudgetOrderPayload> {
    type: ActionTypes.SET_BUDGET_ORDER;
}

export interface IStartLoadingAction extends Action<IStartLoadingPayload> {
    type: ActionTypes.START_LOADING;
}

export interface IStartLoadingFromScratchAction extends Action<IStartLoadingPayload> {
    type: ActionTypes.START_LOADING_FROM_SCRATCH;
}

export interface IFinishLoadingAction extends Action<IFinishLoadingPayload> {
    type: ActionTypes.FINISH_LOADING;
}

export interface IFailLoadingAction extends Action<IFailLoadingPayload> {
    type: ActionTypes.FAIL_LOADING;
}

export type TAgenciesPayload =
    | IAddMultiFilterPayload
    | IReplaceMultiFilterPayload
    | IRemoveMultiFilterPayload
    | IChangeSingleFilterPayload
    | IResetFiltersPayload
    | ISetBudgetPayload
    | ISetBudgetOrderPayload
    | IStartLoadingPayload
    | IFinishLoadingPayload
    | IFailLoadingPayload;
