import { IAgency, IOffice } from 'client/common/types';

import {
    ActionTypes,
    IAddFormOfficeAction,
    ICancelEditingAction,
    IChangeFormDataAction,
    IChangeFormOfficeAction,
    IFormDataChanges,
    IHideFormPreviewAction,
    IRemoveFormOfficeAction,
    ISelectOfficeAction,
    ISendingFailAction,
    ISendingStartAction,
    ISendingSuccessAction,
    IShowFormPreviewAction,
    IShowOrHideProductsCardAction,
    IStartEditingAction,
    TFormOfficeChanges
} from './types';

export function startEditing(agency: IAgency): IStartEditingAction {
    const {
        name,
        description,
        directBudget,
        site,
        offices
    } = agency;

    const initialData = {
        name,
        description,
        directBudget,
        site,
        offices
    };

    return { type: ActionTypes.START_EDITING, payload: { initialData } };
}

export function cancelEditing(): ICancelEditingAction {
    return { type: ActionTypes.CANCEL_EDITING };
}

export function changeFormData(changes: IFormDataChanges): IChangeFormDataAction {
    return { type: ActionTypes.CHANGE_FORM_DATA, payload: { changes } };
}

export function changeFormOffice(index: number, changes: TFormOfficeChanges): IChangeFormOfficeAction {
    return { type: ActionTypes.CHANGE_FORM_OFFICE, payload: { index, changes } };
}

export function addFormOffice(office: IOffice): IAddFormOfficeAction {
    return { type: ActionTypes.ADD_FORM_OFFICE, payload: { office } };
}

export function removeFormOffice(index: number): IRemoveFormOfficeAction {
    return { type: ActionTypes.REMOVE_FORM_OFFICE, payload: { index } };
}

export function showFormPreview(): IShowFormPreviewAction {
    return { type: ActionTypes.SHOW_FORM_PREVIEW };
}

export function hideFormPreview(): IHideFormPreviewAction {
    return { type: ActionTypes.HIDE_FORM_PREVIEW };
}

export function sendingStart(): ISendingStartAction {
    return { type: ActionTypes.SENDING_START };
}

export function sendingFail(): ISendingFailAction {
    return { type: ActionTypes.SENDING_FAIL };
}

export function sendingSuccess(): ISendingSuccessAction {
    return { type: ActionTypes.SENDING_SUCCESS };
}

export function selectOffice(officeId: number): ISelectOfficeAction {
    return { type: ActionTypes.SELECT_OFFICE, payload: { officeId } };
}

export function showOrHideProductsCard(certificateName: 'market'| 'direct' | 'metrika' | 'toloka' |'dialogs', showProductsCard: boolean): IShowOrHideProductsCardAction {
    return { type: ActionTypes.SHOW_OR_HIDE_PRODUCT_CARD, payload: { certificateName, showProductsCard } };
}
